/*
 * Decompiled with CFR 0.152.
 */
package com.canon.tools.console;

import com.canon.tools.console.ListenThread;
import com.canon.tools.console.OKDialog;
import com.canon.tools.console.ReceiveThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;

public class Console
extends JFrame
implements ActionListener {
    static final String DEFAULT_HOST = "localhost";
    static final int DEFAULT_PORT = 19001;
    static final int DEFAULT_TELLPORT = 9002;
    static final int DEFAULT_MAXLINE = 10000;
    static final int DEFAULT_ROWS = 30;
    static final int DEFAULT_COLUMNS = 80;
    static final int MAXLINEOVER = 100;
    static final String DEFAULT_FILENAME_TO_WRITE = "console.log";
    static final String TOP_BUTTON_LABEL = "TOP";
    static final String BOTTOM_BUTTON_LABEL = "BOTTOM";
    static final String CLEAR_BUTTON_LABEL = "CLEAR";
    static final String ALLSELECT_BUTTON_LABEL = "All Select";
    static final String ALLCOPY_BUTTON_LABEL = "COPY";
    static final String LINEUP_COMMAND = "LineUp";
    static final String LINEDOWN_COMMAND = "LineDown";
    static final String PAGEUP_COMMAND = "PageUp";
    static final String PAGEDOWN_COMMAND = "PageDown";
    static String host;
    static int port;
    static int maxLine;
    static int rows;
    static int columns;
    JTextArea textArea;
    JScrollPane scrollPane;
    ServerSocket serverSocket;
    Socket socket;
    BufferedOutputStream out;
    BufferedReader in;
    String savedDirectory;
    JPanel p1;
    Dimension p1dimension;
    String fileNameToWrite;
    PrintWriter outfile;
    ListenThread listenThread;

    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] stringArray) {
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            block22: {
                if (stringArray[n].equals("-host")) {
                    if (n + 1 < stringArray.length && stringArray[n + 1].charAt(0) != '-') {
                        host = stringArray[++n];
                        break block22;
                    } else {
                        Console.usage();
                        return;
                    }
                }
                if (stringArray[n].equals("-port")) {
                    if (n + 1 < stringArray.length && stringArray[n + 1].charAt(0) != '-') {
                        port = Integer.parseInt(stringArray[++n]);
                        break block22;
                    } else {
                        Console.usage();
                        return;
                    }
                }
                if (stringArray[n].equals("-maxline")) {
                    if (n + 1 < stringArray.length && stringArray[n + 1].charAt(0) != '-') {
                        maxLine = Integer.parseInt(stringArray[++n]);
                        break block22;
                    } else {
                        Console.usage();
                        return;
                    }
                }
                if (stringArray[n].equals("-row")) {
                    if (n + 1 < stringArray.length && stringArray[n + 1].charAt(0) != '-') {
                        rows = Integer.parseInt(stringArray[++n]);
                        break block22;
                    } else {
                        Console.usage();
                        return;
                    }
                }
                if (stringArray[n].equals("-column")) {
                    if (n + 1 < stringArray.length && stringArray[n + 1].charAt(0) != '-') {
                        columns = Integer.parseInt(stringArray[++n]);
                        break block22;
                    } else {
                        Console.usage();
                        return;
                    }
                }
                if (stringArray[n].equals("-write")) {
                    string = n + 1 < stringArray.length && stringArray[n + 1].charAt(0) != '-' ? stringArray[++n] : DEFAULT_FILENAME_TO_WRITE;
                } else if (stringArray[n].equals("-help")) {
                    Console.usage();
                    return;
                }
            }
            ++n;
        }
        if (host == null) {
            System.err.println("-host option not found.\n");
            Console.usage();
            return;
        }
        Console console = new Console();
        console.pack();
        console.p1dimension = console.p1.getSize();
        if (string != null) {
            console.initOutFile(string);
        }
        console.show();
        if (host == null) {
            console.listen();
            return;
        }
        console.connect();
    }

    public static void usage() {
        System.err.print("Copyright (c) 2001,2002 Canon, Inc. All Rights Reserved.\nusage: java -jar Console.jar  [options] or\n       java -cp Console.jar com.canon.tools.console.Console [options]\noption:\n  -host host_name         : the host name to which this connects. mandatory.\n  -maxline maxline_number : the maximum number of remembered lines.\n                            (default " + maxLine + ")\n" + "  -write [logfilepath]    : write the displayed data to a log file.\n" + "                            (default \"" + DEFAULT_FILENAME_TO_WRITE + "\")\n" + "  -help                   : display this message.\n");
    }

    public Console() {
        this.setTitle("Console");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                try {
                    if (Console.this.serverSocket != null) {
                        Console.this.serverSocket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                System.exit(0);
            }
        });
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.p1 = new JPanel();
        this.textArea = new JTextArea(rows, columns);
        this.textArea.setEditable(false);
        this.scrollPane = new JScrollPane(this.textArea);
        this.p1.add(this.scrollPane);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(TOP_BUTTON_LABEL);
        jPanel.add(jButton);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(BOTTOM_BUTTON_LABEL);
        jPanel.add(jButton2);
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton(CLEAR_BUTTON_LABEL);
        jPanel.add(jButton3);
        jButton3.addActionListener(this);
        JButton jButton4 = new JButton(ALLCOPY_BUTTON_LABEL);
        jPanel.add(jButton4);
        jButton4.addActionListener(this);
        container.add((Component)this.p1, "Center");
        container.add((Component)jPanel, "South");
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        this.addMenu(jMenu, new JMenuItem("Save"));
        JMenuItem jMenuItem = new JMenuItem("Reconnect");
        this.addMenu(jMenu, jMenuItem);
        jMenu.addSeparator();
        this.addMenu(jMenu, new JMenuItem("Exit"));
        jMenuBar.add(jMenu);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(82, 2);
        jMenuItem.setAccelerator(keyStroke);
        jMenu.setMnemonic(70);
        jMenuItem.setMnemonic(82);
        this.p1.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Component component = componentEvent.getComponent();
                Dimension dimension = component.getSize();
                if (Console.this.p1dimension != null) {
                    Console.this.textArea.setRows((int)((double)(dimension.height * rows / Console.this.p1dimension.height) * 0.9));
                    Console.this.textArea.setColumns((int)((double)(dimension.width * columns / Console.this.p1dimension.width) * 0.9));
                }
                Console.this.textArea.invalidate();
                Console.this.validate();
                Console.this.repaint();
            }
        });
    }

    public void addMenu(JMenu jMenu, JMenuItem jMenuItem) {
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
    }

    public void registerKeyboard(JComponent jComponent, String string, int n) {
        jComponent.registerKeyboardAction(this, string, KeyStroke.getKeyStroke(n, 0, false), 2);
    }

    public void initOutFile(String string) {
        try {
            this.outfile = new PrintWriter((Writer)new FileWriter(string), true);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    public void listen() {
        this.listenThread = new ListenThread(this);
        this.listenThread.start();
    }

    public void connect() {
        try {
            new ReceiveThread(this).start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void print(char[] cArray, int n, int n2) {
        this.print(new String(cArray, n, n2));
    }

    public void print(final String string) {
        if (this.outfile != null) {
            this.outfile.print(string);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Console.this.textArea.append(string);
                int n = Console.this.textArea.getLineCount();
                if (n - maxLine >= 100) {
                    int n2;
                    try {
                        n2 = Console.this.textArea.getLineEndOffset(n - maxLine - 1);
                    }
                    catch (BadLocationException badLocationException) {
                        n2 = 1;
                    }
                    Console.this.textArea.replaceRange(null, 0, n2);
                }
            }
        });
    }

    public void println(String string) {
        this.print(string + "\n");
    }

    public void printStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        String string = byteArrayOutputStream.toString();
        this.println(string);
    }

    public void printException(Throwable throwable) {
        this.println(throwable.toString());
        this.printStackTrace(throwable);
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public void setOut(BufferedOutputStream bufferedOutputStream) {
        this.out = bufferedOutputStream;
    }

    public void setIn(BufferedReader bufferedReader) {
        this.in = bufferedReader;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(TOP_BUTTON_LABEL)) {
            JViewport jViewport = this.scrollPane.getViewport();
            jViewport.setViewPosition(new Point(0, 0));
        } else if (string.equals(BOTTOM_BUTTON_LABEL)) {
            JViewport jViewport = this.scrollPane.getViewport();
            Dimension dimension = jViewport.getViewSize();
            Dimension dimension2 = jViewport.getExtentSize();
            jViewport.setViewPosition(new Point(0, dimension.height - dimension2.height));
        } else if (string.equals(CLEAR_BUTTON_LABEL)) {
            this.textArea.setText(null);
        } else if (string.equals(ALLSELECT_BUTTON_LABEL)) {
            this.textArea.selectAll();
        } else if (string.equals(ALLCOPY_BUTTON_LABEL)) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(this.textArea.getText());
            clipboard.setContents(stringSelection, null);
        } else if (string.equals("Save")) {
            Object object;
            String string2;
            String string3;
            Date date = new Date();
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            String string4 = String.valueOf(gregorianCalendar.get(1) - 2000);
            if (string4.length() == 1) {
                string4 = "0" + string4;
            }
            if ((string3 = String.valueOf(gregorianCalendar.get(2) + 1)).length() == 1) {
                string3 = "0" + string3;
            }
            if ((string2 = String.valueOf(gregorianCalendar.get(5))).length() == 1) {
                string2 = "0" + string2;
            }
            String string5 = "log" + string4 + string3 + string2 + "-";
            int n = string5.length();
            String string6 = this.savedDirectory == null ? "." : this.savedDirectory;
            String[] stringArray = new File(string6).list();
            int n2 = -1;
            int n3 = 0;
            while (n3 < stringArray.length) {
                int n4;
                if (stringArray[n3].startsWith(string5) && (n4 = stringArray[n3].lastIndexOf(".txt")) >= 0) {
                    object = stringArray[n3].substring(n, n4);
                    int n5 = -1;
                    try {
                        n5 = Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println(numberFormatException.toString() + ":" + (String)object);
                    }
                    if (n2 < n5) {
                        n2 = n5;
                    }
                }
                ++n3;
            }
            String string7 = ++n2 < 10 ? "0" + String.valueOf(n2) : String.valueOf(n2);
            string5 = string5 + string7 + ".txt";
            object = new FileDialog((Frame)this, "Save the selected part or the entire to a file", 1);
            ((FileDialog)object).setDirectory(string6);
            ((FileDialog)object).setFile(string5);
            ((Dialog)object).show();
            string5 = ((FileDialog)object).getFile();
            if (string5 == null) {
                return;
            }
            string6 = ((FileDialog)object).getDirectory();
            try {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string6 + string5)));
                String string8 = this.textArea.getSelectedText();
                if (string8 == null) {
                    string8 = this.textArea.getText();
                }
                printWriter.print(string8);
                printWriter.close();
                this.savedDirectory = string6;
            }
            catch (IOException iOException) {
                OKDialog oKDialog = new OKDialog((Frame)this, "File write error", "Failed to write to the file");
                Dimension dimension = this.getSize();
                Dimension dimension3 = oKDialog.getSize();
                Point point = this.getLocation();
                ((Component)oKDialog).setLocation(Math.abs(dimension.width - dimension3.width) / 2 + point.x, Math.abs(dimension.height - dimension3.height) / 2 + point.y);
                oKDialog.show();
            }
        } else if (string.equals("Reconnect")) {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {}
            } else if (this.serverSocket != null) {
                this.listenThread.close();
            }
        } else if (string.equals("Exit")) {
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.outfile != null) {
                this.outfile.flush();
                this.outfile.close();
            }
            System.exit(0);
        } else {
            System.err.println("other command " + string);
        }
    }

    static {
        port = 19001;
        maxLine = 10000;
        rows = 30;
        columns = 80;
    }
}

